
#ifndef __typedef_Def_H
#define __typedef_Def_H



typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned int   DWORD;
typedef unsigned int   BOOL;
typedef bit BIT;


//-------------------------------------------------------------
typedef unsigned char uint8_t;
typedef unsigned int uint16_t;
typedef unsigned long uint32_t;

typedef unsigned char U8;
typedef unsigned int U16;
typedef unsigned long U32;

typedef signed char S8;
typedef signed int S16;
typedef signed long S32;
//-------------------------------------------------------------
typedef union
{
    BYTE B[2];
    WORD W;
} WTYPE;
typedef union
{
    uint8_t B[4];
    uint16_t W[2];
    uint32_t DW;
} DWTYPE;
typedef union
{
    uint8_t  B[2];
    uint16_t H;
} ctype16;

typedef union UU16
{
    U16 U16;
    S16 S16;
    U8 U8[2];
    S8 S8[2];
} UU16;

typedef union UU32
{
    U32 U32;
    S32 S32;
    UU16 UU16[2];
    U16 U16[2];
    S16 S16[2];
    U8 U8[4];
    S8 S8[4];
} UU32;


typedef enum
{
    DRV_ENABLE,
    DRV_DISABLE,
} FunctionalState;

typedef enum
{
    DRV_Set = 1,
    DRV_Clr = 0,
} FlagReturn;

typedef enum 
{
    BMC_5bit = 0,    
    BMC_8bit = 1,    
} UART1_BMCMode_Def; 

//-------------------------------------------------------------
//-------------------------------------------------------------
// DMA source symbol
/**
 * @enum		DMA_SourceSymbol
 * @brief		DMA source perpherial
 */
typedef enum
{
    DMA_SrcDisable = 0x00,
    DMA_SrcS0RX = 0x10,
    DMA_SrcS1RX = 0x20,
    DMA_SrcS2RX = 0x30,
    DMA_SrcS3RX = 0x40,
    DMA_SrcTWI0RX = 0x50,
    DMA_SrcTWI1RX = 0x60,
    DMA_SrcSPI0RX = 0x70,
    DMA_SrcSPI1RX = 0x80,
    DMA_SrcADC = 0x90,
    DMA_SrcUSBRX0 = 0xA0,
    DMA_SrcUSBRX1 = 0xB0,
    DMA_SrcFlash = 0xE0,
    DMA_SrcXRAM = 0xF0,
} DMA_SourceSymbol;
//-------------------------------------------------------------
// DMA Destination symbol
/**
 * @enum		DMA_DestinationSymbol
 * @brief		DMA Destination perpherial
 */

typedef enum
{
    DMA_DestDisable = 0x00,
    DMA_DestS0TX = 0x01,
    DMA_DestS1TX = 0x02,
    DMA_DestS2TX = 0x03,
    DMA_DestS3TX = 0x04,
    DMA_DestTWI0TX = 0x05,
    DMA_DestTWI1TX = 0x06,
    DMA_DestSPI0TX = 0x07,
    DMA_DestSPI1TX = 0x08,
    DMA_DestDAC = 0x09,
    DMA_DestUSBTX0 = 0x0A,
    DMA_DestUSBTX1 = 0x0B,
    DMA_DestGPL_WR = 0x0D,
    DMA_DestFlash = 0x0E,
    DMA_DestXRAM = 0x0F,
} DMA_DestinationSymbol;


#define BMC_4bto5b 0
#define BMC_5bto4b 1

#define SUP_LED_5V  P35
#define SUP_LED_9V  P33
#define SUP_LED_12V P26
#define SUP_LED_15V P23
#define SUP_LED_20V P17


#define SEL_LED_5V  P34
#define SEL_LED_9V  P32
#define SEL_LED_12V P24
#define SEL_LED_15V P22
#define SEL_LED_20V P16

#define SET_KEY P41
#define SELECT_KEY P40

#define TXD1 P13
#define TXD1_1 P11
#define SYNC1   0x18
#define SYNC2   0x11
#define RST1    0x07
#define RST2    0x19
#define EOP 0x0D
#define EOF1 0xE0
#define RX_EOP  0x8D


typedef enum
{
    DRV_ON,
    DRV_OFF,
} LEDState;

#define delay_4nop() _nop_ (); _nop_ (); _nop_ (); _nop_ ();

#define delay_5nop() _nop_ (); _nop_ (); _nop_ (); _nop_ (); _nop_ ();

#define delay_10nop()   delay_5nop()\
    delay_5nop()

#define delay_20nop()   delay_10nop()\
    delay_10nop()

#define delay_50nop()   delay_10nop()\
    delay_20nop()\
    delay_20nop()

/**
* @name	============== GPIO ==============
*
*/
///@{
typedef enum {P44_P45_Fun = 0, OCD_Fun = !P44_P45_Fun} P44_P45_Function;
typedef enum {P47_Fun = 0, RST_Fun = !P47_Fun} P47_Function;


void GPIO_P47_Function_Config(P47_Function);
void GPIO_P44_P45_Function_Config(P44_P45_Function);
///@}
#endif